package com.xforceplus.jcdongchedi.controller;


/**
 * 系统工作流流程实例历史对象feign客户端
 *
 * @author ultraman
 * @date 2025-03-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcdongchedi.entity.SysFlowInsHis;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-dongchedi")
public interface SysFlowInsHisFeignApi {

  /**
   * 通过id查询系统工作流流程实例历史对象
   * @param  id
   * @return R
   */
  @GetMapping("/sysFlowInsHis/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统工作流流程实例历史对象
   * @param sysFlowInsHis 系统工作流流程实例历史对象
   * @return R
   */
  @PostMapping("/sysFlowInsHis/add")
  public R save(@RequestBody SysFlowInsHis sysFlowInsHis);

  /**
   * 修改系统工作流流程实例历史对象
   * @param sysFlowInsHis 系统工作流流程实例历史对象
   * @return R
   */
  @PostMapping("/sysFlowInsHis/update")
  public R updateById(@RequestBody SysFlowInsHis sysFlowInsHis);

  /**
   * 通过id删除系统工作流流程实例历史对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/sysFlowInsHis/del/{id}" )
  public R removeById(@PathVariable Long id);

}