package com.xforceplus.jchanhui.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-03-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ScanBuss implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务明细ID
   */
  @TableField("bussId")
  private String bussId;

  /**
   * 会计科目编码
   */
  @TableField("accountCode")
  private String accountCode;

  /**
   * 会计科目
   */
  @TableField("accountName")
  private String accountName;

  /**
   * 会计科目大类
   */
  @TableField("accountNameLarge")
  private String accountNameLarge;

  /**
   * 影像ID
   */
  @TableField("imageId")
  private String imageId;

  /**
   * 发票ID
   */
  @TableField("invoiceId")
  private String invoiceId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据号
   */
  @TableField("billCode")
  private String billCode;

  /**
   * 费用发生日期
   */
  @TableField("costHappenDate")
  private String costHappenDate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bussId", bussId);
      map.put("accountCode", accountCode);
      map.put("accountName", accountName);
      map.put("accountNameLarge", accountNameLarge);
      map.put("imageId", imageId);
      map.put("invoiceId", invoiceId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billCode", billCode);
      map.put("costHappenDate", costHappenDate);
      return map;
  }

  public static ScanBuss fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ScanBuss entity = new ScanBuss();
    if(map.containsKey("bussId")) {
      Object obj = map.get("bussId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBussId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountCode")) {
      Object obj = map.get("accountCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountName")) {
      Object obj = map.get("accountName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountNameLarge")) {
      Object obj = map.get("accountNameLarge");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountNameLarge((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imageId")) {
      Object obj = map.get("imageId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billCode")) {
      Object obj = map.get("billCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costHappenDate")) {
      Object obj = map.get("costHappenDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostHappenDate((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bussId")) {
      Object obj = map.get("bussId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBussId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountCode")) {
      Object obj = map.get("accountCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountName")) {
      Object obj = map.get("accountName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountNameLarge")) {
      Object obj = map.get("accountNameLarge");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountNameLarge((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imageId")) {
      Object obj = map.get("imageId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImageId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billCode")) {
      Object obj = map.get("billCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costHappenDate")) {
      Object obj = map.get("costHappenDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostHappenDate((String)obj);
        }
      } else {
      }
    }
  }
}
