package com.xforceplus.jchfgf.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchfgf.entity.AllPurchaseInvoice;
import com.xforceplus.jchfgf.service.IAllPurchaseInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-30
 */
@RestController
public class AllPurchaseInvoiceController {

  @Autowired
  private IAllPurchaseInvoiceService allPurchaseInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allPurchaseInvoice ${table.comment}
   * @return
   */
  @GetMapping("/allpurchaseinvoices" )
  public XfR getAllPurchaseInvoices(XfPage page, AllPurchaseInvoice allPurchaseInvoice) {
    return XfR.ok(allPurchaseInvoiceServiceImpl.page(page, Wrappers.query(allPurchaseInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/allpurchaseinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allPurchaseInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param allPurchaseInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/allpurchaseinvoices")
  public XfR save(@RequestBody AllPurchaseInvoice allPurchaseInvoice) {
     return XfR.ok(allPurchaseInvoiceServiceImpl.save(allPurchaseInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param allPurchaseInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/allpurchaseinvoices/{id}")
  public XfR putUpdate(@RequestBody AllPurchaseInvoice allPurchaseInvoice,@PathVariable Long id) {
      allPurchaseInvoice.setId(id);
      return XfR.ok(allPurchaseInvoiceServiceImpl.updateById(allPurchaseInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param allPurchaseInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/allpurchaseinvoices/{id}")
  public XfR patchUpdate(@RequestBody AllPurchaseInvoice allPurchaseInvoice,@PathVariable Long id) {
      AllPurchaseInvoice upallPurchaseInvoice = allPurchaseInvoiceServiceImpl.getById(id);
      if(upallPurchaseInvoice != null){
        upallPurchaseInvoice = ObjectCopyUtils.copyProperties(allPurchaseInvoice,upallPurchaseInvoice,true);
      }
      return XfR.ok(allPurchaseInvoiceServiceImpl.updateById(upallPurchaseInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allpurchaseinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allPurchaseInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/allpurchaseinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "all_purchase_invoice");
     params.put("request", condition);

     return XfR.ok(allPurchaseInvoiceServiceImpl.querys(params));
  }

}
