package com.xforceplus.jchfgf.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchfgf.entity.AllPurchaseInvoiceItem;
import com.xforceplus.jchfgf.service.IAllPurchaseInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-30
 */
@RestController
public class AllPurchaseInvoiceItemController {

  @Autowired
  private IAllPurchaseInvoiceItemService allPurchaseInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allPurchaseInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/allpurchaseinvoiceitems" )
  public XfR getAllPurchaseInvoiceItems(XfPage page, AllPurchaseInvoiceItem allPurchaseInvoiceItem) {
    return XfR.ok(allPurchaseInvoiceItemServiceImpl.page(page, Wrappers.query(allPurchaseInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/allpurchaseinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allPurchaseInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param allPurchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/allpurchaseinvoiceitems")
  public XfR save(@RequestBody AllPurchaseInvoiceItem allPurchaseInvoiceItem) {
     return XfR.ok(allPurchaseInvoiceItemServiceImpl.save(allPurchaseInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param allPurchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/allpurchaseinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody AllPurchaseInvoiceItem allPurchaseInvoiceItem,@PathVariable Long id) {
      allPurchaseInvoiceItem.setId(id);
      return XfR.ok(allPurchaseInvoiceItemServiceImpl.updateById(allPurchaseInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param allPurchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/allpurchaseinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody AllPurchaseInvoiceItem allPurchaseInvoiceItem,@PathVariable Long id) {
      AllPurchaseInvoiceItem upallPurchaseInvoiceItem = allPurchaseInvoiceItemServiceImpl.getById(id);
      if(upallPurchaseInvoiceItem != null){
        upallPurchaseInvoiceItem = ObjectCopyUtils.copyProperties(allPurchaseInvoiceItem,upallPurchaseInvoiceItem,true);
      }
      return XfR.ok(allPurchaseInvoiceItemServiceImpl.updateById(upallPurchaseInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allpurchaseinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allPurchaseInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/allpurchaseinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "all_purchase_invoice_item");
     params.put("request", condition);

     return XfR.ok(allPurchaseInvoiceItemServiceImpl.querys(params));
  }

}
