package com.xforceplus.jchfgf.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchfgf.entity.AllSalesInvoice;
import com.xforceplus.jchfgf.service.IAllSalesInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 销项全量发票池，来源导入前端控制器
 *
 * @author ultraman
 * @date 2024-01-30
 */
@RestController
public class AllSalesInvoiceController {

  @Autowired
  private IAllSalesInvoiceService allSalesInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allSalesInvoice 销项全量发票池，来源导入
   * @return
   */
  @GetMapping("/allsalesinvoices" )
  public XfR getAllSalesInvoices(XfPage page, AllSalesInvoice allSalesInvoice) {
    return XfR.ok(allSalesInvoiceServiceImpl.page(page, Wrappers.query(allSalesInvoice)));
  }

  /**
   * 通过id查询销项全量发票池，来源导入
   * @param  id
   * @return XfR
   */
  @GetMapping("/allsalesinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allSalesInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增销项全量发票池，来源导入
   * @param allSalesInvoice 销项全量发票池，来源导入
   * @return XfR
   */
  @PostMapping("/allsalesinvoices")
  public XfR save(@RequestBody AllSalesInvoice allSalesInvoice) {
     return XfR.ok(allSalesInvoiceServiceImpl.save(allSalesInvoice));
  }

  /**
   * 修改-传入修改后的全部数据销项全量发票池，来源导入
   * @param allSalesInvoice 销项全量发票池，来源导入
   * @return XfR
   */
  @PutMapping("/allsalesinvoices/{id}")
  public XfR putUpdate(@RequestBody AllSalesInvoice allSalesInvoice,@PathVariable Long id) {
      allSalesInvoice.setId(id);
      return XfR.ok(allSalesInvoiceServiceImpl.updateById(allSalesInvoice));
  }

  /**
   * 修改-传入修改的数据销项全量发票池，来源导入
   * @param allSalesInvoice 销项全量发票池，来源导入
   * @return XfR
   */
  @PatchMapping("/allsalesinvoices/{id}")
  public XfR patchUpdate(@RequestBody AllSalesInvoice allSalesInvoice,@PathVariable Long id) {
      AllSalesInvoice upallSalesInvoice = allSalesInvoiceServiceImpl.getById(id);
      if(upallSalesInvoice != null){
        upallSalesInvoice = ObjectCopyUtils.copyProperties(allSalesInvoice,upallSalesInvoice,true);
      }
      return XfR.ok(allSalesInvoiceServiceImpl.updateById(upallSalesInvoice));
  }

  /**
   * 通过id删除销项全量发票池，来源导入
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allsalesinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allSalesInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/allsalesinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "all_sales_invoice");
     params.put("request", condition);

     return XfR.ok(allSalesInvoiceServiceImpl.querys(params));
  }

}
