package com.xforceplus.jchfgf.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchfgf.entity.AllSalesInvoiceItem;
import com.xforceplus.jchfgf.service.IAllSalesInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-30
 */
@RestController
public class AllSalesInvoiceItemController {

  @Autowired
  private IAllSalesInvoiceItemService allSalesInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allSalesInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/allsalesinvoiceitems" )
  public XfR getAllSalesInvoiceItems(XfPage page, AllSalesInvoiceItem allSalesInvoiceItem) {
    return XfR.ok(allSalesInvoiceItemServiceImpl.page(page, Wrappers.query(allSalesInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/allsalesinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allSalesInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param allSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/allsalesinvoiceitems")
  public XfR save(@RequestBody AllSalesInvoiceItem allSalesInvoiceItem) {
     return XfR.ok(allSalesInvoiceItemServiceImpl.save(allSalesInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param allSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/allsalesinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody AllSalesInvoiceItem allSalesInvoiceItem,@PathVariable Long id) {
      allSalesInvoiceItem.setId(id);
      return XfR.ok(allSalesInvoiceItemServiceImpl.updateById(allSalesInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param allSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/allsalesinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody AllSalesInvoiceItem allSalesInvoiceItem,@PathVariable Long id) {
      AllSalesInvoiceItem upallSalesInvoiceItem = allSalesInvoiceItemServiceImpl.getById(id);
      if(upallSalesInvoiceItem != null){
        upallSalesInvoiceItem = ObjectCopyUtils.copyProperties(allSalesInvoiceItem,upallSalesInvoiceItem,true);
      }
      return XfR.ok(allSalesInvoiceItemServiceImpl.updateById(upallSalesInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allsalesinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allSalesInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/allsalesinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "all_sales_invoice_item");
     params.put("request", condition);

     return XfR.ok(allSalesInvoiceItemServiceImpl.querys(params));
  }

}
