package com.xforceplus.jchsufuchifoods.controller;


/**
 * 通用规则配置feign客户端
 *
 * @author ultraman
 * @date 2023-11-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.GeneralRuleConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-hsufuchifoods")
public interface GeneralRuleConfigFeignApi {

  /**
   * 通过id查询通用规则配置
   * @param  id
   * @return R
   */
  @GetMapping("/generalRuleConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增通用规则配置
   * @param generalRuleConfig 通用规则配置
   * @return R
   */
  @PostMapping("/generalRuleConfig/add")
  public R save(@RequestBody GeneralRuleConfig generalRuleConfig);

  /**
   * 修改通用规则配置
   * @param generalRuleConfig 通用规则配置
   * @return R
   */
  @PostMapping("/generalRuleConfig/update")
  public R updateById(@RequestBody GeneralRuleConfig generalRuleConfig);

  /**
   * 通过id删除通用规则配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/generalRuleConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}