package com.xforceplus.jchsufuchifoods.controller;


/**
 * 业务单关联关系feign客户端
 *
 * @author ultraman
 * @date 2023-11-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.SalesBillRelation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-hsufuchifoods")
public interface SalesBillRelationFeignApi {

  /**
   * 通过id查询业务单关联关系
   * @param  id
   * @return R
   */
  @GetMapping("/salesBillRelation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务单关联关系
   * @param salesBillRelation 业务单关联关系
   * @return R
   */
  @PostMapping("/salesBillRelation/add")
  public R save(@RequestBody SalesBillRelation salesBillRelation);

  /**
   * 修改业务单关联关系
   * @param salesBillRelation 业务单关联关系
   * @return R
   */
  @PostMapping("/salesBillRelation/update")
  public R updateById(@RequestBody SalesBillRelation salesBillRelation);

  /**
   * 通过id删除业务单关联关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesBillRelation/del/{id}" )
  public R removeById(@PathVariable Long id);

}