package com.xforceplus.jchsufuchifoods.controller;


/**
 * 销方信息配置feign客户端
 *
 * @author ultraman
 * @date 2023-11-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.SellerInfoConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-hsufuchifoods")
public interface SellerInfoConfigFeignApi {

  /**
   * 通过id查询销方信息配置
   * @param  id
   * @return R
   */
  @GetMapping("/sellerInfoConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增销方信息配置
   * @param sellerInfoConfig 销方信息配置
   * @return R
   */
  @PostMapping("/sellerInfoConfig/add")
  public R save(@RequestBody SellerInfoConfig sellerInfoConfig);

  /**
   * 修改销方信息配置
   * @param sellerInfoConfig 销方信息配置
   * @return R
   */
  @PostMapping("/sellerInfoConfig/update")
  public R updateById(@RequestBody SellerInfoConfig sellerInfoConfig);

  /**
   * 通过id删除销方信息配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/sellerInfoConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}