package com.xforceplus.jchsufuchifoods.controller;


/**
 * 业务单组合规则feign客户端
 *
 * @author ultraman
 * @date 2024-05-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.ConfigRule;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-hsufuchifoods")
public interface ConfigRuleFeignApi {

  /**
   * 通过id查询业务单组合规则
   * @param  id
   * @return R
   */
  @GetMapping("/configRule/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务单组合规则
   * @param configRule 业务单组合规则
   * @return R
   */
  @PostMapping("/configRule/add")
  public R save(@RequestBody ConfigRule configRule);

  /**
   * 修改业务单组合规则
   * @param configRule 业务单组合规则
   * @return R
   */
  @PostMapping("/configRule/update")
  public R updateById(@RequestBody ConfigRule configRule);

  /**
   * 通过id删除业务单组合规则
   * @param  id
   * @return R
   */
  @DeleteMapping("/configRule/del/{id}" )
  public R removeById(@PathVariable Long id);

}