package com.xforceplus.jchsufuchifoods.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-05-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.DistributorInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-hsufuchifoods")
public interface DistributorInfoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/distributorInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param distributorInfo ${table.comment}
   * @return R
   */
  @PostMapping("/distributorInfo/add")
  public R save(@RequestBody DistributorInfo distributorInfo);

  /**
   * 修改${table.comment}
   * @param distributorInfo ${table.comment}
   * @return R
   */
  @PostMapping("/distributorInfo/update")
  public R updateById(@RequestBody DistributorInfo distributorInfo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/distributorInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}