package com.xforceplus.jchsufuchifoods.controller;


/**
 * 预制发票操作日志feign客户端
 *
 * @author ultraman
 * @date 2024-05-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.PreInvoiceOpLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-hsufuchifoods")
public interface PreInvoiceOpLogFeignApi {

  /**
   * 通过id查询预制发票操作日志
   * @param  id
   * @return R
   */
  @GetMapping("/preInvoiceOpLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增预制发票操作日志
   * @param preInvoiceOpLog 预制发票操作日志
   * @return R
   */
  @PostMapping("/preInvoiceOpLog/add")
  public R save(@RequestBody PreInvoiceOpLog preInvoiceOpLog);

  /**
   * 修改预制发票操作日志
   * @param preInvoiceOpLog 预制发票操作日志
   * @return R
   */
  @PostMapping("/preInvoiceOpLog/update")
  public R updateById(@RequestBody PreInvoiceOpLog preInvoiceOpLog);

  /**
   * 通过id删除预制发票操作日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/preInvoiceOpLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}