package com.xforceplus.jchsufuchifoods.controller;


/**
 * 红字信息表主信息feign客户端
 *
 * @author ultraman
 * @date 2024-05-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.RedLetterInvoiceMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-hsufuchifoods")
public interface RedLetterInvoiceMainFeignApi {

  /**
   * 通过id查询红字信息表主信息
   * @param  id
   * @return R
   */
  @GetMapping("/redLetterInvoiceMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增红字信息表主信息
   * @param redLetterInvoiceMain 红字信息表主信息
   * @return R
   */
  @PostMapping("/redLetterInvoiceMain/add")
  public R save(@RequestBody RedLetterInvoiceMain redLetterInvoiceMain);

  /**
   * 修改红字信息表主信息
   * @param redLetterInvoiceMain 红字信息表主信息
   * @return R
   */
  @PostMapping("/redLetterInvoiceMain/update")
  public R updateById(@RequestBody RedLetterInvoiceMain redLetterInvoiceMain);

  /**
   * 通过id删除红字信息表主信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/redLetterInvoiceMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}