package com.xforceplus.jchsufuchifoods.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单价数量方式
 * </p>
 *
 * @author ultraman
 * @since 2021-06-28
 */
public enum PriceQuantityMethod {

    _1("1", "保单价"),
    _2("2", "保单价且数量取整"),
    _3("3", "保数量"),
    _4("4", "保数量且数量取整");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PriceQuantityMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PriceQuantityMethod fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
