package com.xforceplus.jchsufuchifoods.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理状态
 * </p>
 *
 * @author ultraman
 * @since 2021-11-29
 */
public enum ProcessStatus {

    WAIT("wait", "待上传"),
    FAIL("fail", "上传失败"),
    SUCCESS("success", "上传成功"),
    ABANDON("abandon", "已作废");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessStatus fromCode(String code){
        switch(code) {
            case "wait":
                return WAIT;
            case "fail":
                return FAIL;
            case "success":
                return SUCCESS;
            case "abandon":
                return ABANDON;
            default:
                return null;
        }
    }
}
