package com.xforceplus.jchsufuchifoods.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 系统数据来源
 * </p>
 *
 * @author ultraman
 * @since 2021-11-29
 */
public enum SystemOrigEnum {

    RED_LETTER("redLetter", "红字信息表"),
    PRE_INVOICE("preInvoice", "预制发票"),
    EXCEL("excel", "导入");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SystemOrigEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SystemOrigEnum fromCode(String code){
        switch(code) {
            case "redLetter":
                return RED_LETTER;
            case "preInvoice":
                return PRE_INVOICE;
            case "excel":
                return EXCEL;
            default:
                return null;
        }
    }
}
