package com.xforceplus.jchsufuchifoods.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.SellerInfoConfig;
import com.xforceplus.jchsufuchifoods.service.ISellerInfoConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-29
 */
@RestController
public class SellerInfoConfigController {

  @Autowired
  private ISellerInfoConfigService sellerInfoConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInfoConfig ${table.comment}
   * @return
   */
  @GetMapping("/sellerinfoconfigs" )
  public XfR getSellerInfoConfigs(XfPage page, SellerInfoConfig sellerInfoConfig) {
    return XfR.ok(sellerInfoConfigServiceImpl.page(page, Wrappers.query(sellerInfoConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinfoconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInfoConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sellerInfoConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/sellerinfoconfigs")
  public XfR save(@RequestBody SellerInfoConfig sellerInfoConfig) {
     return XfR.ok(sellerInfoConfigServiceImpl.save(sellerInfoConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sellerInfoConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/sellerinfoconfigs/{id}")
  public XfR putUpdate(@RequestBody SellerInfoConfig sellerInfoConfig,@PathVariable Long id) {
      sellerInfoConfig.setId(id);
      return XfR.ok(sellerInfoConfigServiceImpl.updateById(sellerInfoConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sellerInfoConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sellerinfoconfigs/{id}")
  public XfR patchUpdate(@RequestBody SellerInfoConfig sellerInfoConfig,@PathVariable Long id) {
      SellerInfoConfig upsellerInfoConfig = sellerInfoConfigServiceImpl.getById(id);
      if(upsellerInfoConfig != null){
        upsellerInfoConfig = ObjectCopyUtils.copyProperties(sellerInfoConfig,upsellerInfoConfig,true);
      }
      return XfR.ok(sellerInfoConfigServiceImpl.updateById(upsellerInfoConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinfoconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInfoConfigServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinfoconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_info_config");
     params.put("request", condition);

     return XfR.ok(sellerInfoConfigServiceImpl.querys(params));
  }

}
