package com.xforceplus.jchsufuchifoods.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.GeneralRuleConfig;
import com.xforceplus.jchsufuchifoods.service.IGeneralRuleConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-01
 */
@RestController
public class GeneralRuleConfigController {

  @Autowired
  private IGeneralRuleConfigService generalRuleConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param generalRuleConfig ${table.comment}
   * @return
   */
  @GetMapping("/generalruleconfigs" )
  public XfR getGeneralRuleConfigs(XfPage page, GeneralRuleConfig generalRuleConfig) {
    return XfR.ok(generalRuleConfigServiceImpl.page(page, Wrappers.query(generalRuleConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/generalruleconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(generalRuleConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param generalRuleConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/generalruleconfigs")
  public XfR save(@RequestBody GeneralRuleConfig generalRuleConfig) {
     return XfR.ok(generalRuleConfigServiceImpl.save(generalRuleConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param generalRuleConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/generalruleconfigs/{id}")
  public XfR putUpdate(@RequestBody GeneralRuleConfig generalRuleConfig,@PathVariable Long id) {
      generalRuleConfig.setId(id);
      return XfR.ok(generalRuleConfigServiceImpl.updateById(generalRuleConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param generalRuleConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/generalruleconfigs/{id}")
  public XfR patchUpdate(@RequestBody GeneralRuleConfig generalRuleConfig,@PathVariable Long id) {
      GeneralRuleConfig upgeneralRuleConfig = generalRuleConfigServiceImpl.getById(id);
      if(upgeneralRuleConfig != null){
        upgeneralRuleConfig = ObjectCopyUtils.copyProperties(generalRuleConfig,upgeneralRuleConfig,true);
      }
      return XfR.ok(generalRuleConfigServiceImpl.updateById(upgeneralRuleConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/generalruleconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(generalRuleConfigServiceImpl.removeById(id));
  }

  @PostMapping("/generalruleconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "general_rule_config");
     params.put("request", condition);

     return XfR.ok(generalRuleConfigServiceImpl.querys(params));
  }

}
