package com.xforceplus.jchsufuchifoods.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.SalesBillRelation;
import com.xforceplus.jchsufuchifoods.service.ISalesBillRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-01
 */
@RestController
public class SalesBillRelationController {

  @Autowired
  private ISalesBillRelationService salesBillRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesBillRelation ${table.comment}
   * @return
   */
  @GetMapping("/salesbillrelations" )
  public XfR getSalesBillRelations(XfPage page, SalesBillRelation salesBillRelation) {
    return XfR.ok(salesBillRelationServiceImpl.page(page, Wrappers.query(salesBillRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbillrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesBillRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesBillRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesbillrelations")
  public XfR save(@RequestBody SalesBillRelation salesBillRelation) {
     return XfR.ok(salesBillRelationServiceImpl.save(salesBillRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesBillRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesbillrelations/{id}")
  public XfR putUpdate(@RequestBody SalesBillRelation salesBillRelation,@PathVariable Long id) {
      salesBillRelation.setId(id);
      return XfR.ok(salesBillRelationServiceImpl.updateById(salesBillRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesBillRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesbillrelations/{id}")
  public XfR patchUpdate(@RequestBody SalesBillRelation salesBillRelation,@PathVariable Long id) {
      SalesBillRelation upsalesBillRelation = salesBillRelationServiceImpl.getById(id);
      if(upsalesBillRelation != null){
        upsalesBillRelation = ObjectCopyUtils.copyProperties(salesBillRelation,upsalesBillRelation,true);
      }
      return XfR.ok(salesBillRelationServiceImpl.updateById(upsalesBillRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbillrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesBillRelationServiceImpl.removeById(id));
  }

  @PostMapping("/salesbillrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_bill_relation");
     params.put("request", condition);

     return XfR.ok(salesBillRelationServiceImpl.querys(params));
  }

}
