package com.xforceplus.jchsufuchifoods.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.PreInvoiceOpLog;
import com.xforceplus.jchsufuchifoods.service.IPreInvoiceOpLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-02
 */
@RestController
public class PreInvoiceOpLogController {

  @Autowired
  private IPreInvoiceOpLogService preInvoiceOpLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param preInvoiceOpLog ${table.comment}
   * @return
   */
  @GetMapping("/preinvoiceoplogs" )
  public XfR getPreInvoiceOpLogs(XfPage page, PreInvoiceOpLog preInvoiceOpLog) {
    return XfR.ok(preInvoiceOpLogServiceImpl.page(page, Wrappers.query(preInvoiceOpLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/preinvoiceoplogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(preInvoiceOpLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param preInvoiceOpLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/preinvoiceoplogs")
  public XfR save(@RequestBody PreInvoiceOpLog preInvoiceOpLog) {
     return XfR.ok(preInvoiceOpLogServiceImpl.save(preInvoiceOpLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param preInvoiceOpLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/preinvoiceoplogs/{id}")
  public XfR putUpdate(@RequestBody PreInvoiceOpLog preInvoiceOpLog,@PathVariable Long id) {
      preInvoiceOpLog.setId(id);
      return XfR.ok(preInvoiceOpLogServiceImpl.updateById(preInvoiceOpLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param preInvoiceOpLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/preinvoiceoplogs/{id}")
  public XfR patchUpdate(@RequestBody PreInvoiceOpLog preInvoiceOpLog,@PathVariable Long id) {
      PreInvoiceOpLog uppreInvoiceOpLog = preInvoiceOpLogServiceImpl.getById(id);
      if(uppreInvoiceOpLog != null){
        uppreInvoiceOpLog = ObjectCopyUtils.copyProperties(preInvoiceOpLog,uppreInvoiceOpLog,true);
      }
      return XfR.ok(preInvoiceOpLogServiceImpl.updateById(uppreInvoiceOpLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/preinvoiceoplogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(preInvoiceOpLogServiceImpl.removeById(id));
  }

  @PostMapping("/preinvoiceoplogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pre_invoice_op_log");
     params.put("request", condition);

     return XfR.ok(preInvoiceOpLogServiceImpl.querys(params));
  }

}
