package com.xforceplus.jchsufuchifoods.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jchsufuchifoods.entity.RedLetterInvoiceMain;
import com.xforceplus.jchsufuchifoods.service.IRedLetterInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-02
 */
@RestController
public class RedLetterInvoiceMainController {

  @Autowired
  private IRedLetterInvoiceMainService redLetterInvoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redLetterInvoiceMain ${table.comment}
   * @return
   */
  @GetMapping("/redletterinvoicemains" )
  public XfR getRedLetterInvoiceMains(XfPage page, RedLetterInvoiceMain redLetterInvoiceMain) {
    return XfR.ok(redLetterInvoiceMainServiceImpl.page(page, Wrappers.query(redLetterInvoiceMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redletterinvoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redLetterInvoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redLetterInvoiceMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/redletterinvoicemains")
  public XfR save(@RequestBody RedLetterInvoiceMain redLetterInvoiceMain) {
     return XfR.ok(redLetterInvoiceMainServiceImpl.save(redLetterInvoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redLetterInvoiceMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/redletterinvoicemains/{id}")
  public XfR putUpdate(@RequestBody RedLetterInvoiceMain redLetterInvoiceMain,@PathVariable Long id) {
      redLetterInvoiceMain.setId(id);
      return XfR.ok(redLetterInvoiceMainServiceImpl.updateById(redLetterInvoiceMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redLetterInvoiceMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redletterinvoicemains/{id}")
  public XfR patchUpdate(@RequestBody RedLetterInvoiceMain redLetterInvoiceMain,@PathVariable Long id) {
      RedLetterInvoiceMain upredLetterInvoiceMain = redLetterInvoiceMainServiceImpl.getById(id);
      if(upredLetterInvoiceMain != null){
        upredLetterInvoiceMain = ObjectCopyUtils.copyProperties(redLetterInvoiceMain,upredLetterInvoiceMain,true);
      }
      return XfR.ok(redLetterInvoiceMainServiceImpl.updateById(upredLetterInvoiceMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redletterinvoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redLetterInvoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/redletterinvoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_letter_invoice_main");
     params.put("request", condition);

     return XfR.ok(redLetterInvoiceMainServiceImpl.querys(params));
  }

}
