package com.xforceplus.jchuazhu.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-07-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.OfflineInvoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-huazhu")
public interface OfflineInvoiceFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/offlineInvoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param offlineInvoice ${table.comment}
   * @return R
   */
  @PostMapping("/offlineInvoice/add")
  public R save(@RequestBody OfflineInvoice offlineInvoice);

  /**
   * 修改${table.comment}
   * @param offlineInvoice ${table.comment}
   * @return R
   */
  @PostMapping("/offlineInvoice/update")
  public R updateById(@RequestBody OfflineInvoice offlineInvoice);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/offlineInvoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}