package com.xforceplus.jchuazhu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 用户类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-08
 */
public enum SubdomainCode {

    S("S", "供应商"),
    EHR("EHR", "EHR员工");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SubdomainCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubdomainCode fromCode(String code){
        switch(code) {
            case "S":
                return S;
            case "EHR":
                return EHR;
            default:
                return null;
        }
    }
}
