package com.xforceplus.jchuazhu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 客商性质
 * </p>
 *
 * @author ultraman
 * @since 2023-05-18
 */
public enum MerchantProperty {

    _1("1", "华住公司"),
    _2("2", "直营门店"),
    _3("3", "加盟门店"),
    _4("4", "外部企业"),
    _5("5", "华住员工");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MerchantProperty(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MerchantProperty fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
