package com.xforceplus.jchuazhu.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-05-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Company implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 公司编号
   */
  @TableField("companyNo")
  private String companyNo;

  /**
   * 公司税号
   */
  @TableField("companyTaxNo")
  private String companyTaxNo;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 酒店唯一编号
   */
  @TableField("hotelUnifyNo")
  private String hotelUnifyNo;

  /**
   * 开户行名称
   */
  @TableField("bankName")
  private String bankName;

  /**
   * 开户行账号
   */
  @TableField("accountNumber")
  private String accountNumber;

  /**
   * 地址
   */
  private String address;

  /**
   * 电话
   */
  @TableField("phoneNumber")
  private String phoneNumber;

  /**
   * 组织ID
   */
  @TableField("orgId")
  private String orgId;

  /**
   * 上传平台状态
   */
  @TableField("sendStatus")
  private String sendStatus;

  /**
   * 纳税人规模
   */
  @TableField("taxpayerScale")
  private String taxpayerScale;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("companyNo", companyNo);
      map.put("companyTaxNo", companyTaxNo);
      map.put("companyName", companyName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("hotelUnifyNo", hotelUnifyNo);
      map.put("bankName", bankName);
      map.put("accountNumber", accountNumber);
      map.put("address", address);
      map.put("phoneNumber", phoneNumber);
      map.put("orgId", orgId);
      map.put("sendStatus", sendStatus);
      map.put("taxpayerScale", taxpayerScale);
      return map;
  }

  public static Company fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Company entity = new Company();
    if(map.containsKey("companyNo")) {
      Object obj = map.get("companyNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hotelUnifyNo")) {
      Object obj = map.get("hotelUnifyNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHotelUnifyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phoneNumber")) {
      Object obj = map.get("phoneNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPhoneNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgId")) {
      Object obj = map.get("orgId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendStatus")) {
      Object obj = map.get("sendStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSendStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxpayerScale")) {
      Object obj = map.get("taxpayerScale");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxpayerScale((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("companyNo")) {
      Object obj = map.get("companyNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hotelUnifyNo")) {
      Object obj = map.get("hotelUnifyNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHotelUnifyNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("phoneNumber")) {
      Object obj = map.get("phoneNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPhoneNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orgId")) {
      Object obj = map.get("orgId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sendStatus")) {
      Object obj = map.get("sendStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSendStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxpayerScale")) {
      Object obj = map.get("taxpayerScale");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxpayerScale((String)obj);
        }
      } else {
      }
    }
  }
}
