package com.xforceplus.jchuazhu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 税种
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum TaxType {

    VALUE_ADDED_TAX("valueAddedTax", "增值税"),
    CORPORATE_INCOME_TAX("corporateIncomeTax", "企业所得税"),
    STAMP_DUTY("stampDuty", "印花税"),
    OTHER_SMALL_TAXES("otherSmallTaxes", "其他小税种");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxType fromCode(String code){
        switch(code) {
            case "valueAddedTax":
                return VALUE_ADDED_TAX;
            case "corporateIncomeTax":
                return CORPORATE_INCOME_TAX;
            case "stampDuty":
                return STAMP_DUTY;
            case "otherSmallTaxes":
                return OTHER_SMALL_TAXES;
            default:
                return null;
        }
    }
}
