package com.xforceplus.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.DeductionVoucherCompany;
import com.xforceplus.jchuazhu.service.IDeductionVoucherCompanyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class DeductionVoucherCompanyController {

  @Autowired
  private IDeductionVoucherCompanyService deductionVoucherCompanyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deductionVoucherCompany ${table.comment}
   * @return
   */
  @GetMapping("/deductionvouchercompanys" )
  public XfR getDeductionVoucherCompanys(XfPage page, DeductionVoucherCompany deductionVoucherCompany) {
    return XfR.ok(deductionVoucherCompanyServiceImpl.page(page, Wrappers.query(deductionVoucherCompany)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/deductionvouchercompanys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deductionVoucherCompanyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param deductionVoucherCompany ${table.comment}
   * @return XfR
   */
  @PostMapping("/deductionvouchercompanys")
  public XfR save(@RequestBody DeductionVoucherCompany deductionVoucherCompany) {
     return XfR.ok(deductionVoucherCompanyServiceImpl.save(deductionVoucherCompany));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param deductionVoucherCompany ${table.comment}
   * @return XfR
   */
  @PutMapping("/deductionvouchercompanys/{id}")
  public XfR putUpdate(@RequestBody DeductionVoucherCompany deductionVoucherCompany,@PathVariable Long id) {
      deductionVoucherCompany.setId(id);
      return XfR.ok(deductionVoucherCompanyServiceImpl.updateById(deductionVoucherCompany));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param deductionVoucherCompany ${table.comment}
   * @return XfR
   */
  @PatchMapping("/deductionvouchercompanys/{id}")
  public XfR patchUpdate(@RequestBody DeductionVoucherCompany deductionVoucherCompany,@PathVariable Long id) {
      DeductionVoucherCompany updeductionVoucherCompany = deductionVoucherCompanyServiceImpl.getById(id);
      if(updeductionVoucherCompany != null){
        updeductionVoucherCompany = ObjectCopyUtils.copyProperties(deductionVoucherCompany,updeductionVoucherCompany,true);
      }
      return XfR.ok(deductionVoucherCompanyServiceImpl.updateById(updeductionVoucherCompany));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deductionvouchercompanys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deductionVoucherCompanyServiceImpl.removeById(id));
  }

  @PostMapping("/deductionvouchercompanys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "deduction_voucher_company");
     params.put("request", condition);

     return XfR.ok(deductionVoucherCompanyServiceImpl.querys(params));
  }

}
