package com.xforceplus.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.MerchantBasicinfo;
import com.xforceplus.jchuazhu.service.IMerchantBasicinfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class MerchantBasicinfoController {

  @Autowired
  private IMerchantBasicinfoService merchantBasicinfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param merchantBasicinfo ${table.comment}
   * @return
   */
  @GetMapping("/merchantbasicinfos" )
  public XfR getMerchantBasicinfos(XfPage page, MerchantBasicinfo merchantBasicinfo) {
    return XfR.ok(merchantBasicinfoServiceImpl.page(page, Wrappers.query(merchantBasicinfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/merchantbasicinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(merchantBasicinfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param merchantBasicinfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/merchantbasicinfos")
  public XfR save(@RequestBody MerchantBasicinfo merchantBasicinfo) {
     return XfR.ok(merchantBasicinfoServiceImpl.save(merchantBasicinfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param merchantBasicinfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/merchantbasicinfos/{id}")
  public XfR putUpdate(@RequestBody MerchantBasicinfo merchantBasicinfo,@PathVariable Long id) {
      merchantBasicinfo.setId(id);
      return XfR.ok(merchantBasicinfoServiceImpl.updateById(merchantBasicinfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param merchantBasicinfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/merchantbasicinfos/{id}")
  public XfR patchUpdate(@RequestBody MerchantBasicinfo merchantBasicinfo,@PathVariable Long id) {
      MerchantBasicinfo upmerchantBasicinfo = merchantBasicinfoServiceImpl.getById(id);
      if(upmerchantBasicinfo != null){
        upmerchantBasicinfo = ObjectCopyUtils.copyProperties(merchantBasicinfo,upmerchantBasicinfo,true);
      }
      return XfR.ok(merchantBasicinfoServiceImpl.updateById(upmerchantBasicinfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/merchantbasicinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(merchantBasicinfoServiceImpl.removeById(id));
  }

  @PostMapping("/merchantbasicinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "merchant_basicinfo");
     params.put("request", condition);

     return XfR.ok(merchantBasicinfoServiceImpl.querys(params));
  }

}
