package com.xforceplus.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.MerchantCompany;
import com.xforceplus.jchuazhu.service.IMerchantCompanyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class MerchantCompanyController {

  @Autowired
  private IMerchantCompanyService merchantCompanyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param merchantCompany ${table.comment}
   * @return
   */
  @GetMapping("/merchantcompanys" )
  public XfR getMerchantCompanys(XfPage page, MerchantCompany merchantCompany) {
    return XfR.ok(merchantCompanyServiceImpl.page(page, Wrappers.query(merchantCompany)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/merchantcompanys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(merchantCompanyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param merchantCompany ${table.comment}
   * @return XfR
   */
  @PostMapping("/merchantcompanys")
  public XfR save(@RequestBody MerchantCompany merchantCompany) {
     return XfR.ok(merchantCompanyServiceImpl.save(merchantCompany));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param merchantCompany ${table.comment}
   * @return XfR
   */
  @PutMapping("/merchantcompanys/{id}")
  public XfR putUpdate(@RequestBody MerchantCompany merchantCompany,@PathVariable Long id) {
      merchantCompany.setId(id);
      return XfR.ok(merchantCompanyServiceImpl.updateById(merchantCompany));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param merchantCompany ${table.comment}
   * @return XfR
   */
  @PatchMapping("/merchantcompanys/{id}")
  public XfR patchUpdate(@RequestBody MerchantCompany merchantCompany,@PathVariable Long id) {
      MerchantCompany upmerchantCompany = merchantCompanyServiceImpl.getById(id);
      if(upmerchantCompany != null){
        upmerchantCompany = ObjectCopyUtils.copyProperties(merchantCompany,upmerchantCompany,true);
      }
      return XfR.ok(merchantCompanyServiceImpl.updateById(upmerchantCompany));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/merchantcompanys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(merchantCompanyServiceImpl.removeById(id));
  }

  @PostMapping("/merchantcompanys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "merchant_company");
     params.put("request", condition);

     return XfR.ok(merchantCompanyServiceImpl.querys(params));
  }

}
