package com.xforceplus.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.UserInfo;
import com.xforceplus.jchuazhu.service.IUserInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-22
 */
@RestController
public class UserInfoController {

  @Autowired
  private IUserInfoService userInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param userInfo ${table.comment}
   * @return
   */
  @GetMapping("/userinfos" )
  public XfR getUserInfos(XfPage page, UserInfo userInfo) {
    return XfR.ok(userInfoServiceImpl.page(page, Wrappers.query(userInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/userinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(userInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param userInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/userinfos")
  public XfR save(@RequestBody UserInfo userInfo) {
     return XfR.ok(userInfoServiceImpl.save(userInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param userInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/userinfos/{id}")
  public XfR putUpdate(@RequestBody UserInfo userInfo,@PathVariable Long id) {
      userInfo.setId(id);
      return XfR.ok(userInfoServiceImpl.updateById(userInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param userInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/userinfos/{id}")
  public XfR patchUpdate(@RequestBody UserInfo userInfo,@PathVariable Long id) {
      UserInfo upuserInfo = userInfoServiceImpl.getById(id);
      if(upuserInfo != null){
        upuserInfo = ObjectCopyUtils.copyProperties(userInfo,upuserInfo,true);
      }
      return XfR.ok(userInfoServiceImpl.updateById(upuserInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/userinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(userInfoServiceImpl.removeById(id));
  }

  @PostMapping("/userinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "user_info");
     params.put("request", condition);

     return XfR.ok(userInfoServiceImpl.querys(params));
  }

}
