package com.xforceplus.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.OtherOrg;
import com.xforceplus.jchuazhu.service.IOtherOrgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class OtherOrgController {

  @Autowired
  private IOtherOrgService otherOrgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param otherOrg ${table.comment}
   * @return
   */
  @GetMapping("/otherorgs" )
  public XfR getOtherOrgs(XfPage page, OtherOrg otherOrg) {
    return XfR.ok(otherOrgServiceImpl.page(page, Wrappers.query(otherOrg)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/otherorgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(otherOrgServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param otherOrg ${table.comment}
   * @return XfR
   */
  @PostMapping("/otherorgs")
  public XfR save(@RequestBody OtherOrg otherOrg) {
     return XfR.ok(otherOrgServiceImpl.save(otherOrg));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param otherOrg ${table.comment}
   * @return XfR
   */
  @PutMapping("/otherorgs/{id}")
  public XfR putUpdate(@RequestBody OtherOrg otherOrg,@PathVariable Long id) {
      otherOrg.setId(id);
      return XfR.ok(otherOrgServiceImpl.updateById(otherOrg));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param otherOrg ${table.comment}
   * @return XfR
   */
  @PatchMapping("/otherorgs/{id}")
  public XfR patchUpdate(@RequestBody OtherOrg otherOrg,@PathVariable Long id) {
      OtherOrg upotherOrg = otherOrgServiceImpl.getById(id);
      if(upotherOrg != null){
        upotherOrg = ObjectCopyUtils.copyProperties(otherOrg,upotherOrg,true);
      }
      return XfR.ok(otherOrgServiceImpl.updateById(upotherOrg));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/otherorgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(otherOrgServiceImpl.removeById(id));
  }

  @PostMapping("/otherorgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "other_org");
     params.put("request", condition);

     return XfR.ok(otherOrgServiceImpl.querys(params));
  }

}
