package com.xforceplus.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.MerchantInfo;
import com.xforceplus.jchuazhu.service.IMerchantInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-23
 */
@RestController
public class MerchantInfoController {

  @Autowired
  private IMerchantInfoService merchantInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param merchantInfo ${table.comment}
   * @return
   */
  @GetMapping("/merchantinfos" )
  public XfR getMerchantInfos(XfPage page, MerchantInfo merchantInfo) {
    return XfR.ok(merchantInfoServiceImpl.page(page, Wrappers.query(merchantInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/merchantinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(merchantInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param merchantInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/merchantinfos")
  public XfR save(@RequestBody MerchantInfo merchantInfo) {
     return XfR.ok(merchantInfoServiceImpl.save(merchantInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param merchantInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/merchantinfos/{id}")
  public XfR putUpdate(@RequestBody MerchantInfo merchantInfo,@PathVariable Long id) {
      merchantInfo.setId(id);
      return XfR.ok(merchantInfoServiceImpl.updateById(merchantInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param merchantInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/merchantinfos/{id}")
  public XfR patchUpdate(@RequestBody MerchantInfo merchantInfo,@PathVariable Long id) {
      MerchantInfo upmerchantInfo = merchantInfoServiceImpl.getById(id);
      if(upmerchantInfo != null){
        upmerchantInfo = ObjectCopyUtils.copyProperties(merchantInfo,upmerchantInfo,true);
      }
      return XfR.ok(merchantInfoServiceImpl.updateById(upmerchantInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/merchantinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(merchantInfoServiceImpl.removeById(id));
  }

  @PostMapping("/merchantinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "merchant_info");
     params.put("request", condition);

     return XfR.ok(merchantInfoServiceImpl.querys(params));
  }

}
