package com.xforceplus.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.TokenDto;
import com.xforceplus.jchuazhu.service.ITokenDtoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-23
 */
@RestController
public class TokenDtoController {

  @Autowired
  private ITokenDtoService tokenDtoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tokenDto ${table.comment}
   * @return
   */
  @GetMapping("/tokendtos" )
  public XfR getTokenDtos(XfPage page, TokenDto tokenDto) {
    return XfR.ok(tokenDtoServiceImpl.page(page, Wrappers.query(tokenDto)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tokendtos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tokenDtoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tokenDto ${table.comment}
   * @return XfR
   */
  @PostMapping("/tokendtos")
  public XfR save(@RequestBody TokenDto tokenDto) {
     return XfR.ok(tokenDtoServiceImpl.save(tokenDto));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tokenDto ${table.comment}
   * @return XfR
   */
  @PutMapping("/tokendtos/{id}")
  public XfR putUpdate(@RequestBody TokenDto tokenDto,@PathVariable Long id) {
      tokenDto.setId(id);
      return XfR.ok(tokenDtoServiceImpl.updateById(tokenDto));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tokenDto ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tokendtos/{id}")
  public XfR patchUpdate(@RequestBody TokenDto tokenDto,@PathVariable Long id) {
      TokenDto uptokenDto = tokenDtoServiceImpl.getById(id);
      if(uptokenDto != null){
        uptokenDto = ObjectCopyUtils.copyProperties(tokenDto,uptokenDto,true);
      }
      return XfR.ok(tokenDtoServiceImpl.updateById(uptokenDto));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tokendtos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tokenDtoServiceImpl.removeById(id));
  }

  @PostMapping("/tokendtos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "token_dto");
     params.put("request", condition);

     return XfR.ok(tokenDtoServiceImpl.querys(params));
  }

}
