package com.xforceplus.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.UserInfoModel;
import com.xforceplus.jchuazhu.service.IUserInfoModelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-23
 */
@RestController
public class UserInfoModelController {

  @Autowired
  private IUserInfoModelService userInfoModelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param userInfoModel ${table.comment}
   * @return
   */
  @GetMapping("/userinfomodels" )
  public XfR getUserInfoModels(XfPage page, UserInfoModel userInfoModel) {
    return XfR.ok(userInfoModelServiceImpl.page(page, Wrappers.query(userInfoModel)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/userinfomodels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(userInfoModelServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param userInfoModel ${table.comment}
   * @return XfR
   */
  @PostMapping("/userinfomodels")
  public XfR save(@RequestBody UserInfoModel userInfoModel) {
     return XfR.ok(userInfoModelServiceImpl.save(userInfoModel));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param userInfoModel ${table.comment}
   * @return XfR
   */
  @PutMapping("/userinfomodels/{id}")
  public XfR putUpdate(@RequestBody UserInfoModel userInfoModel,@PathVariable Long id) {
      userInfoModel.setId(id);
      return XfR.ok(userInfoModelServiceImpl.updateById(userInfoModel));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param userInfoModel ${table.comment}
   * @return XfR
   */
  @PatchMapping("/userinfomodels/{id}")
  public XfR patchUpdate(@RequestBody UserInfoModel userInfoModel,@PathVariable Long id) {
      UserInfoModel upuserInfoModel = userInfoModelServiceImpl.getById(id);
      if(upuserInfoModel != null){
        upuserInfoModel = ObjectCopyUtils.copyProperties(userInfoModel,upuserInfoModel,true);
      }
      return XfR.ok(userInfoModelServiceImpl.updateById(upuserInfoModel));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/userinfomodels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(userInfoModelServiceImpl.removeById(id));
  }

  @PostMapping("/userinfomodels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "user_info_model");
     params.put("request", condition);

     return XfR.ok(userInfoModelServiceImpl.querys(params));
  }

}
