package com.xforceplus.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jchuazhu.entity.InvoiceDto;
import com.xforceplus.jchuazhu.service.IInvoiceDtoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-21
 */
@RestController
public class InvoiceDtoController {

  @Autowired
  private IInvoiceDtoService invoiceDtoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceDto ${table.comment}
   * @return
   */
  @GetMapping("/invoicedtos" )
  public XfR getInvoiceDtos(XfPage page, InvoiceDto invoiceDto) {
    return XfR.ok(invoiceDtoServiceImpl.page(page, Wrappers.query(invoiceDto)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedtos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceDtoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceDto ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicedtos")
  public XfR save(@RequestBody InvoiceDto invoiceDto) {
     return XfR.ok(invoiceDtoServiceImpl.save(invoiceDto));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceDto ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicedtos/{id}")
  public XfR putUpdate(@RequestBody InvoiceDto invoiceDto,@PathVariable Long id) {
      invoiceDto.setId(id);
      return XfR.ok(invoiceDtoServiceImpl.updateById(invoiceDto));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceDto ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicedtos/{id}")
  public XfR patchUpdate(@RequestBody InvoiceDto invoiceDto,@PathVariable Long id) {
      InvoiceDto upinvoiceDto = invoiceDtoServiceImpl.getById(id);
      if(upinvoiceDto != null){
        upinvoiceDto = ObjectCopyUtils.copyProperties(invoiceDto,upinvoiceDto,true);
      }
      return XfR.ok(invoiceDtoServiceImpl.updateById(upinvoiceDto));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedtos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceDtoServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedtos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_dto");
     params.put("request", condition);

     return XfR.ok(invoiceDtoServiceImpl.querys(params));
  }

}
