package com.xforceplus.jcinvoiceikea.controller;


/**
 * 导入结果明细信息feign客户端
 *
 * @author ultraman
 * @date 2021-12-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcinvoiceikea.entity.ImportResultDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-invoice-ikea")
public interface ImportResultDetailFeignApi {

  /**
   * 通过id查询导入结果明细信息
   * @param  id
   * @return R
   */
  @GetMapping("/importResultDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增导入结果明细信息
   * @param importResultDetail 导入结果明细信息
   * @return R
   */
  @PostMapping("/importResultDetail/add")
  public R save(@RequestBody ImportResultDetail importResultDetail);

  /**
   * 修改导入结果明细信息
   * @param importResultDetail 导入结果明细信息
   * @return R
   */
  @PostMapping("/importResultDetail/update")
  public R updateById(@RequestBody ImportResultDetail importResultDetail);

  /**
   * 通过id删除导入结果明细信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/importResultDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}