package com.xforceplus.jcinvoiceikea.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 2. EQB202105 72150110-72150138
 * </p>
 *
 * @author ultraman
 * @since 2021-12-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Eqb implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * Internal Invoice No.
   */
  @TableField("internalInvoiceNo")
  private String internalInvoiceNo;

  /**
   * Invoice Date
   */
  @TableField("invoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;

  /**
   * Cust Name
   */
  @TableField("custName")
  private String custName;

  /**
   * Item Group ID
   */
  @TableField("itemGroupID")
  private String itemGroupID;

  /**
   * Item ID
   */
  @TableField("itemID")
  private String itemID;

  /**
   * Item Desc
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * Order No.
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * Your Order No.
   */
  @TableField("yourOrderNo")
  private String yourOrderNo;

  /**
   * CN Description
   */
  @TableField("cnDescription")
  private String cnDescription;

  /**
   * Curr
   */
  private String curr;

  /**
   * Price
   */
  private String price;

  /**
   * Qty
   */
  private String qty;

  /**
   * Amt
   */
  private String amt;

  /**
   * Freight
   */
  private String freight;

  /**
   * Charge
   */
  private String charge;

  /**
   * Goods values
   */
  @TableField("goodsValues")
  private String goodsValues;

  /**
   * Tax
   */
  private String tax;

  /**
   * Total inv amount
   */
  @TableField("totalInvAmount")
  private String totalInvAmount;

  /**
   * WH
   */
  private String wh;

  /**
   * Purchase
   */
  private String purchase;

  /**
   * SupplierID
   */
  @TableField("supplierID")
  private String supplierID;

  /**
   * Supplier Name
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * Supp invoice no
   */
  @TableField("suppInvoiceNo")
  private String suppInvoiceNo;

  /**
   * Supp Curr
   */
  @TableField("suppCurr")
  private String suppCurr;

  /**
   * Supp Amt
   */
  @TableField("suppAmt")
  private String suppAmt;

  /**
   * VAT发票号
   */
  @TableField("vatInvoiceNo")
  private String vatInvoiceNo;

  /**
   * 开票日期
   */
  @TableField("originDate")
  private String originDate;

  /**
   * 快递单号
   */
  @TableField("courieNo")
  private String courieNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("internalInvoiceNo", internalInvoiceNo);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("custName", custName);
      map.put("itemGroupID", itemGroupID);
      map.put("itemID", itemID);
      map.put("itemDesc", itemDesc);
      map.put("orderNo", orderNo);
      map.put("yourOrderNo", yourOrderNo);
      map.put("cnDescription", cnDescription);
      map.put("curr", curr);
      map.put("price", price);
      map.put("qty", qty);
      map.put("amt", amt);
      map.put("freight", freight);
      map.put("charge", charge);
      map.put("goodsValues", goodsValues);
      map.put("tax", tax);
      map.put("totalInvAmount", totalInvAmount);
      map.put("wh", wh);
      map.put("purchase", purchase);
      map.put("supplierID", supplierID);
      map.put("supplierName", supplierName);
      map.put("suppInvoiceNo", suppInvoiceNo);
      map.put("suppCurr", suppCurr);
      map.put("suppAmt", suppAmt);
      map.put("vatInvoiceNo", vatInvoiceNo);
      map.put("originDate", originDate);
      map.put("courieNo", courieNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static Eqb fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Eqb entity = new Eqb();
    if(map.containsKey("internalInvoiceNo")) {
      Object obj = map.get("internalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInternalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("custName")) {
      Object obj = map.get("custName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemGroupID")) {
      Object obj = map.get("itemGroupID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemGroupID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemID")) {
      Object obj = map.get("itemID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("yourOrderNo")) {
      Object obj = map.get("yourOrderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setYourOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cnDescription")) {
      Object obj = map.get("cnDescription");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCnDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("curr")) {
      Object obj = map.get("curr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amt")) {
      Object obj = map.get("amt");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freight")) {
      Object obj = map.get("freight");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFreight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge")) {
      Object obj = map.get("charge");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCharge((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsValues")) {
      Object obj = map.get("goodsValues");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsValues((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalInvAmount")) {
      Object obj = map.get("totalInvAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalInvAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wh")) {
      Object obj = map.get("wh");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase")) {
      Object obj = map.get("purchase");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchase((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierID")) {
      Object obj = map.get("supplierID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("suppInvoiceNo")) {
      Object obj = map.get("suppInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSuppInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("suppCurr")) {
      Object obj = map.get("suppCurr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSuppCurr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("suppAmt")) {
      Object obj = map.get("suppAmt");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSuppAmt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatInvoiceNo")) {
      Object obj = map.get("vatInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originDate")) {
      Object obj = map.get("originDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("courieNo")) {
      Object obj = map.get("courieNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCourieNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
