package com.xforceplus.jcinvoiceikea.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-12
 */
public enum BillType {

    _1("1", "WholeSaler"),
    _2("2", "出口倒开票"),
    _0("0", "EQB"),
    _3("3", "配件");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "0":
                return _0;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
