package com.xforceplus.jcinvoiceikea.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 字段取值类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-12
 */
public enum FieldValueType {

    VALUE("VALUE", "取默认值"),
    LOGIC("LOGIC", "逻辑运算字段"),
    SUM("SUM", "求和字段");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FieldValueType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FieldValueType fromCode(String code){
        switch(code) {
            case "VALUE":
                return VALUE;
            case "LOGIC":
                return LOGIC;
            case "SUM":
                return SUM;
            default:
                return null;
        }
    }
}
