package com.xforceplus.jcinvoiceikea.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件名映射公司字典
 * </p>
 *
 * @author ultraman
 * @since 2022-01-12
 */
public enum FileNameToComNo {

    IDS("IDS", "4967"),
    IPS("IPS", "4990"),
    I("I", "4992"),
    _7700("7700", "7700"),
    _4967("4967", "4967"),
    _4990("4990", "4990"),
    _4992("4992", "4992"),
    STO("STO", "7700"),
    CDC("CDC", "7700"),
    RGR("RGR", "7700"),
    _7718("7718", "7718");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FileNameToComNo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileNameToComNo fromCode(String code){
        switch(code) {
            case "IDS":
                return IDS;
            case "IPS":
                return IPS;
            case "I":
                return I;
            case "7700":
                return _7700;
            case "4967":
                return _4967;
            case "4990":
                return _4990;
            case "4992":
                return _4992;
            case "STO":
                return STO;
            case "CDC":
                return CDC;
            case "RGR":
                return RGR;
            case "7718":
                return _7718;
            default:
                return null;
        }
    }
}
