package com.xforceplus.jcinvoiceikea.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据处理状态
 * </p>
 *
 * @author ultraman
 * @since 2022-01-12
 */
public enum HandleStatus {

    _0("0", "全部失败"),
    _1("1", "部分成功"),
    _2("2", "全部成功"),
    _3("3", "处理中"),
    _4("4", "准备处理");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    HandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandleStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
