package com.xforceplus.jcinvoiceikea.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 3. comp Sales Record_v2
 * </p>
 *
 * @author ultraman
 * @since 2022-01-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CompSalesRecord implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * Whs
   */
  private String whs;

  /**
   * Order Tp
   */
  @TableField("orderTp")
  private String orderTp;

  /**
   * Country
   */
  private String country;

  /**
   * Cust
   */
  private String cust;

  /**
   * Cust Nm
   */
  @TableField("custNm")
  private String custNm;

  /**
   * Order No
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * Inv No
   */
  @TableField("invNo")
  private String invNo;

  /**
   * Item No
   */
  @TableField("itemNo")
  private String itemNo;

  /**
   * Item name
   */
  @TableField("itemName")
  private String itemName;

  /**
   * Item name (CN)
   */
  @TableField("itemNameCn")
  private String itemNameCn;

  /**
   * Unit
   */
  private String unit;

  /**
   * Price
   */
  private String price;

  /**
   * Inv Amount
   */
  @TableField("invAmount")
  private String invAmount;

  /**
   * Inv Amt(VAT)
   */
  @TableField("invAmtVAT")
  private String invAmtVAT;

  /**
   * Currency
   */
  private String currency;

  /**
   * Exchange rate
   */
  @TableField("exchangeRate")
  private String exchangeRate;

  /**
   * Inv Dt
   */
  @TableField("invDt")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invDt;

  /**
   * Inv Sts
   */
  @TableField("invSts")
  private String invSts;

  /**
   * Dely Qty
   */
  @TableField("delyQty")
  private String delyQty;

  /**
   * Dely Dt
   */
  @TableField("delyDt")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime delyDt;

  /**
   * LineTp
   */
  @TableField("lineTp")
  private String lineTp;

  /**
   * Customers order number
   */
  @TableField("customersOrderNumber")
  private String customersOrderNumber;

  /**
   * Note
   */
  private String note;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * Inv Qty
   */
  @TableField("invQty")
  private BigDecimal invQty;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("whs", whs);
      map.put("orderTp", orderTp);
      map.put("country", country);
      map.put("cust", cust);
      map.put("custNm", custNm);
      map.put("orderNo", orderNo);
      map.put("invNo", invNo);
      map.put("itemNo", itemNo);
      map.put("itemName", itemName);
      map.put("itemNameCn", itemNameCn);
      map.put("unit", unit);
      map.put("price", price);
      map.put("invAmount", invAmount);
      map.put("invAmtVAT", invAmtVAT);
      map.put("currency", currency);
      map.put("exchangeRate", exchangeRate);
      map.put("invDt", BocpGenUtils.toTimestamp(invDt));
      map.put("invSts", invSts);
      map.put("delyQty", delyQty);
      map.put("delyDt", BocpGenUtils.toTimestamp(delyDt));
      map.put("lineTp", lineTp);
      map.put("customersOrderNumber", customersOrderNumber);
      map.put("note", note);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invQty", invQty);
      return map;
  }

  public static CompSalesRecord fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CompSalesRecord entity = new CompSalesRecord();
    if(map.containsKey("whs")) {
      Object obj = map.get("whs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWhs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderTp")) {
      Object obj = map.get("orderTp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderTp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust")) {
      Object obj = map.get("cust");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCust((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custNm")) {
      Object obj = map.get("custNm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustNm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invNo")) {
      Object obj = map.get("invNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNo")) {
      Object obj = map.get("itemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNameCn")) {
      Object obj = map.get("itemNameCn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemNameCn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invAmount")) {
      Object obj = map.get("invAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invAmtVAT")) {
      Object obj = map.get("invAmtVAT");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvAmtVAT((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exchangeRate")) {
      Object obj = map.get("exchangeRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExchangeRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invDt")) {
      Object obj = map.get("invDt");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvDt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvDt((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvDt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvDt(null);
      }
    }
    if(map.containsKey("invSts")) {
      Object obj = map.get("invSts");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvSts((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delyQty")) {
      Object obj = map.get("delyQty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDelyQty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delyDt")) {
      Object obj = map.get("delyDt");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDelyDt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDelyDt((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDelyDt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDelyDt(null);
      }
    }
    if(map.containsKey("lineTp")) {
      Object obj = map.get("lineTp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLineTp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customersOrderNumber")) {
      Object obj = map.get("customersOrderNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomersOrderNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("note")) {
      Object obj = map.get("note");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNote((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invQty")) {
      Object obj = map.get("invQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }
}
