package com.xforceplus.jcinvoiceikea.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 导入结果主信息
 * </p>
 *
 * @author ultraman
 * @since 2022-01-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ImportResultHead implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 处理反馈结果
   */
  @TableField("processRemark")
  private String processRemark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 导入批次
   */
  @TableField("batchNo")
  private String batchNo;

  /**
   * 请求信息
   */
  @TableField("requestBody")
  private String requestBody;

  /**
   * 返回信息
   */
  @TableField("responseBody")
  private String responseBody;

  /**
   * 处理单据位置
   */
  @TableField("aliveBill")
  private Long aliveBill;

  /**
   * 总单据数量
   */
  @TableField("billCount")
  private Long billCount;

  /**
   * 返回状态码
   */
  @TableField("responseCode")
  private String responseCode;

  /**
   * 文件名
   */
  @TableField("fileName")
  private String fileName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("salesbillNo", salesbillNo);
      map.put("processRemark", processRemark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("batchNo", batchNo);
      map.put("requestBody", requestBody);
      map.put("responseBody", responseBody);
      map.put("aliveBill", aliveBill);
      map.put("billCount", billCount);
      map.put("responseCode", responseCode);
      map.put("fileName", fileName);
      return map;
  }

  public static ImportResultHead fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ImportResultHead entity = new ImportResultHead();
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processRemark")) {
      Object obj = map.get("processRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestBody")) {
      Object obj = map.get("requestBody");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responseBody")) {
      Object obj = map.get("responseBody");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aliveBill")) {
      Object obj = map.get("aliveBill");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAliveBill((Long)obj);
        } else if(obj instanceof String) {
          entity.setAliveBill(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAliveBill(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("billCount")) {
      Object obj = map.get("billCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setBillCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("responseCode")) {
      Object obj = map.get("responseCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
