package com.xforceplus.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcinvoiceikea.entity.CompSalesRecord;
import com.xforceplus.jcinvoiceikea.service.ICompSalesRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 3. comp Sales Record_v2前端控制器
 *
 * @author ultraman
 * @date 2022-10-19
 */
@RestController
public class CompSalesRecordController {

  @Autowired
  private ICompSalesRecordService compSalesRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compSalesRecord 3. comp Sales Record_v2
   * @return
   */
  @GetMapping("/compsalesrecords" )
  public XfR getCompSalesRecords(XfPage page, CompSalesRecord compSalesRecord) {
    return XfR.ok(compSalesRecordServiceImpl.page(page, Wrappers.query(compSalesRecord)));
  }

  /**
   * 通过id查询3. comp Sales Record_v2
   * @param  id
   * @return XfR
   */
  @GetMapping("/compsalesrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compSalesRecordServiceImpl.getById(id));
  }

  /**
   * 新增3. comp Sales Record_v2
   * @param compSalesRecord 3. comp Sales Record_v2
   * @return XfR
   */
  @PostMapping("/compsalesrecords")
  public XfR save(@RequestBody CompSalesRecord compSalesRecord) {
     return XfR.ok(compSalesRecordServiceImpl.save(compSalesRecord));
  }

  /**
   * 修改-传入修改后的全部数据3. comp Sales Record_v2
   * @param compSalesRecord 3. comp Sales Record_v2
   * @return XfR
   */
  @PutMapping("/compsalesrecords/{id}")
  public XfR putUpdate(@RequestBody CompSalesRecord compSalesRecord,@PathVariable Long id) {
      compSalesRecord.setId(id);
      return XfR.ok(compSalesRecordServiceImpl.updateById(compSalesRecord));
  }

  /**
   * 修改-传入修改的数据3. comp Sales Record_v2
   * @param compSalesRecord 3. comp Sales Record_v2
   * @return XfR
   */
  @PatchMapping("/compsalesrecords/{id}")
  public XfR patchUpdate(@RequestBody CompSalesRecord compSalesRecord,@PathVariable Long id) {
      CompSalesRecord upcompSalesRecord = compSalesRecordServiceImpl.getById(id);
      if(upcompSalesRecord != null){
        upcompSalesRecord = ObjectCopyUtils.copyProperties(compSalesRecord,upcompSalesRecord,true);
      }
      return XfR.ok(compSalesRecordServiceImpl.updateById(upcompSalesRecord));
  }

  /**
   * 通过id删除3. comp Sales Record_v2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compsalesrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compSalesRecordServiceImpl.removeById(id));
  }

  @PostMapping("/compsalesrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "comp_sales_record");
     params.put("request", condition);

     return XfR.ok(compSalesRecordServiceImpl.querys(params));
  }

}
