package com.xforceplus.jcjscc.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-07-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ProductAndSubjectConfig implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 产品代码
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 应收科目代码
   */
  @TableField("receivableSubjectCode")
  private String receivableSubjectCode;

  /**
   * 应收科目名称
   */
  @TableField("receivableSubjectName")
  private String receivableSubjectName;

  /**
   * 收入科目代码
   */
  @TableField("incomeSubjectCode")
  private String incomeSubjectCode;

  /**
   * 收入科目名称
   */
  @TableField("incomeSubjectName")
  private String incomeSubjectName;

  /**
   * 税金科目代码
   */
  @TableField("taxSubjectCode")
  private String taxSubjectCode;

  /**
   * 税金科目名称
   */
  @TableField("taxSubjectName")
  private String taxSubjectName;

  /**
   * 交易类型
   */
  @TableField("dealType")
  private String dealType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 productInfo
   */
    private Long productAndConfigId;
  /**
   * 对一关联关系 关联对象 taxSubjectInfo
   */
    private Long configToTaxSubjectId;
  /**
   * 对一关联关系 关联对象 receivableSubjectInfo
   */
    private Long configToReceivableSubjectId;
  /**
   * 对一关联关系 关联对象 incomeSubjectInfo
   */
    private Long configToIncomeSubjectId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("productCode", productCode);
      map.put("productName", productName);
      map.put("receivableSubjectCode", receivableSubjectCode);
      map.put("receivableSubjectName", receivableSubjectName);
      map.put("incomeSubjectCode", incomeSubjectCode);
      map.put("incomeSubjectName", incomeSubjectName);
      map.put("taxSubjectCode", taxSubjectCode);
      map.put("taxSubjectName", taxSubjectName);
      map.put("dealType", dealType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("productAndConfig.id", productAndConfigId);
       map.put("configToTaxSubject.id", configToTaxSubjectId);
       map.put("configToReceivableSubject.id", configToReceivableSubjectId);
       map.put("configToIncomeSubject.id", configToIncomeSubjectId);
      return map;
  }

  public static ProductAndSubjectConfig fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ProductAndSubjectConfig entity = new ProductAndSubjectConfig();
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivableSubjectCode")) {
      Object obj = map.get("receivableSubjectCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableSubjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivableSubjectName")) {
      Object obj = map.get("receivableSubjectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableSubjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("incomeSubjectCode")) {
      Object obj = map.get("incomeSubjectCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIncomeSubjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("incomeSubjectName")) {
      Object obj = map.get("incomeSubjectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIncomeSubjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxSubjectCode")) {
      Object obj = map.get("taxSubjectCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxSubjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxSubjectName")) {
      Object obj = map.get("taxSubjectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxSubjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dealType")) {
      Object obj = map.get("dealType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("productAndConfig.id")) {
        Object obj = map.get("productAndConfig.id");
      if(obj instanceof Long) {
        entity.setProductAndConfigId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setProductAndConfigId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("configToTaxSubject.id")) {
        Object obj = map.get("configToTaxSubject.id");
      if(obj instanceof Long) {
        entity.setConfigToTaxSubjectId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setConfigToTaxSubjectId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("configToReceivableSubject.id")) {
        Object obj = map.get("configToReceivableSubject.id");
      if(obj instanceof Long) {
        entity.setConfigToReceivableSubjectId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setConfigToReceivableSubjectId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("configToIncomeSubject.id")) {
        Object obj = map.get("configToIncomeSubject.id");
      if(obj instanceof Long) {
        entity.setConfigToIncomeSubjectId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setConfigToIncomeSubjectId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivableSubjectCode")) {
      Object obj = map.get("receivableSubjectCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivableSubjectCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivableSubjectName")) {
      Object obj = map.get("receivableSubjectName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivableSubjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("incomeSubjectCode")) {
      Object obj = map.get("incomeSubjectCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIncomeSubjectCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("incomeSubjectName")) {
      Object obj = map.get("incomeSubjectName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIncomeSubjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxSubjectCode")) {
      Object obj = map.get("taxSubjectCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxSubjectCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxSubjectName")) {
      Object obj = map.get("taxSubjectName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxSubjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dealType")) {
      Object obj = map.get("dealType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("productAndConfig.id")) {
        Object obj = map.get("productAndConfig.id");
        if(obj instanceof Long) {
          this.setProductAndConfigId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProductAndConfigId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("configToTaxSubject.id")) {
        Object obj = map.get("configToTaxSubject.id");
        if(obj instanceof Long) {
          this.setConfigToTaxSubjectId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConfigToTaxSubjectId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("configToReceivableSubject.id")) {
        Object obj = map.get("configToReceivableSubject.id");
        if(obj instanceof Long) {
          this.setConfigToReceivableSubjectId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConfigToReceivableSubjectId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("configToIncomeSubject.id")) {
        Object obj = map.get("configToIncomeSubject.id");
        if(obj instanceof Long) {
          this.setConfigToIncomeSubjectId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConfigToIncomeSubjectId(Long.parseLong((String)obj));
        }
      }
  }
}
