package com.xforceplus.jcjscc.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 系统用户任务对象
 * </p>
 *
 * @author ultraman
 * @since 2024-07-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SystemWorkflowUserTask implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 任务名称
   */
  private String name;

  /**
   * 父任务id
   */
  private Long parentTaskId;

  /**
   * 任务描述
   */
  private String description;

  /**
   * 任务优先级
   */
  private String priority;

  /**
   * 任务执行人
   */
  private Long assignee;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 流程id
   */
  private String flowId;

  /**
   * 流程编码
   */
  private String flowCode;

  /**
   * 到期时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dueDate;

  /**
   * 分类
   */
  private String category;

  /**
   * 开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startTime;

  /**
   * 代理状态
   */
  private String delegationStatus;

  /**
   * 任务执行人名称
   */
  private String assigneeName;

  /**
   * 表单唯一键
   */
  private String formKey;

  /**
   * 流程节点实例ID
   */
  private Long actInstanceId;

  /**
   * 子任务的数目
   */
  private Long subTaskNum;

  /**
   * 子任务完成的数目
   */
  private Long subCompleteTaskNum;

  /**
   * 流程实例id
   */
  private String flowInstanceId;

  /**
   * 0:等待处理 1: 完成
   */
  private String status;

  /**
   * 流程节点id
   */
  private String actId;

  /**
   * 乐观锁版本
   */
  private Long version;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("name", name);
      map.put("parent_task_id", parentTaskId);
      map.put("description", description);
      map.put("priority", priority);
      map.put("assignee", assignee);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("flow_id", flowId);
      map.put("flow_code", flowCode);
      map.put("due_date", BocpGenUtils.toTimestamp(dueDate));
      map.put("category", category);
      map.put("start_time", BocpGenUtils.toTimestamp(startTime));
      map.put("delegation_status", delegationStatus);
      map.put("assignee_name", assigneeName);
      map.put("form_key", formKey);
      map.put("act_instance_id", actInstanceId);
      map.put("sub_task_num", subTaskNum);
      map.put("sub_complete_task_num", subCompleteTaskNum);
      map.put("flow_instance_id", flowInstanceId);
      map.put("status", status);
      map.put("act_id", actId);
      map.put("version", version);

      return map;
  }

  public static SystemWorkflowUserTask fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SystemWorkflowUserTask entity = new SystemWorkflowUserTask();
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parent_task_id")) {
      Object obj = map.get("parent_task_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParentTaskId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setParentTaskId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setParentTaskId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("description")) {
      Object obj = map.get("description");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priority")) {
      Object obj = map.get("priority");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPriority((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assignee")) {
      Object obj = map.get("assignee");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAssignee((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAssignee(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAssignee(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flow_id")) {
      Object obj = map.get("flow_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flow_code")) {
      Object obj = map.get("flow_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("due_date")) {
      Object obj = map.get("due_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDueDate(null);
      }
    }
    if(map.containsKey("category")) {
      Object obj = map.get("category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("start_time")) {
      Object obj = map.get("start_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setStartTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartTime(null);
      }
    }
    if(map.containsKey("delegation_status")) {
      Object obj = map.get("delegation_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDelegationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assignee_name")) {
      Object obj = map.get("assignee_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssigneeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("form_key")) {
      Object obj = map.get("form_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFormKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("act_instance_id")) {
      Object obj = map.get("act_instance_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActInstanceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActInstanceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActInstanceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sub_task_num")) {
      Object obj = map.get("sub_task_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubTaskNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSubTaskNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSubTaskNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sub_complete_task_num")) {
      Object obj = map.get("sub_complete_task_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubCompleteTaskNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSubCompleteTaskNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSubCompleteTaskNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("flow_instance_id")) {
      Object obj = map.get("flow_instance_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowInstanceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("act_id")) {
      Object obj = map.get("act_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parent_task_id")) {
      Object obj = map.get("parent_task_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setParentTaskId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setParentTaskId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setParentTaskId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("description")) {
      Object obj = map.get("description");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("priority")) {
      Object obj = map.get("priority");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPriority((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assignee")) {
      Object obj = map.get("assignee");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAssignee((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAssignee(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAssignee(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flow_id")) {
      Object obj = map.get("flow_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flow_code")) {
      Object obj = map.get("flow_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("due_date")) {
      Object obj = map.get("due_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDueDate(null);
      }
    }
    if(map.containsKey("category")) {
      Object obj = map.get("category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("start_time")) {
      Object obj = map.get("start_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setStartTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setStartTime(null);
      }
    }
    if(map.containsKey("delegation_status")) {
      Object obj = map.get("delegation_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDelegationStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assignee_name")) {
      Object obj = map.get("assignee_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssigneeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("form_key")) {
      Object obj = map.get("form_key");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFormKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("act_instance_id")) {
      Object obj = map.get("act_instance_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActInstanceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActInstanceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setActInstanceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sub_task_num")) {
      Object obj = map.get("sub_task_num");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSubTaskNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSubTaskNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSubTaskNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sub_complete_task_num")) {
      Object obj = map.get("sub_complete_task_num");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSubCompleteTaskNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSubCompleteTaskNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSubCompleteTaskNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("flow_instance_id")) {
      Object obj = map.get("flow_instance_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowInstanceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("act_id")) {
      Object obj = map.get("act_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setVersion(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
