package com.xforceplus.jcliutao.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FilterSalesInvoice implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 原发票类型
   */
  @TableField("originalInvoiceType")
  private String originalInvoiceType;

  /**
   * 原蓝票开票日期
   */
  @TableField("originalDateIssued")
  private String originalDateIssued;

  /**
   * 电子签名
   */
  @TableField("electronicSignature")
  private String electronicSignature;

  /**
   * 渠道
   */
  private String channel;

  /**
   * 打印标识（单价和数量）
   */
  @TableField("printContentFlag")
  private String printContentFlag;

  /**
   * 红冲人
   */
  private String reverser;

  /**
   * 打印状态
   */
  @TableField("printStatus")
  private String printStatus;

  /**
   * 作废时间
   */
  @TableField("cancellationTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime cancellationTime;

  /**
   * 作废人
   */
  @TableField("cancellationUser")
  private String cancellationUser;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 扩展字段11
   */
  private String ext11;

  /**
   * 扩展字段12
   */
  private String ext12;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 开票日期
   */
  @TableField("dateIssued")
  private String dateIssued;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 购方名称
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 购方税号
   */
  @TableField("buyerTaxNo")
  private String buyerTaxNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 机器编码
   */
  @TableField("machineCode")
  private String machineCode;

  /**
   * 校验码
   */
  @TableField("checkCode")
  private String checkCode;

  /**
   * 密文
   */
  @TableField("cipherText")
  private String cipherText;

  /**
   * 收款人姓名
   */
  private String payee;

  /**
   * 复核人姓名
   */
  private String reviewer;

  /**
   * 开票人姓名
   */
  private String issuer;

  /**
   * 购方公司编号
   */
  @TableField("buyerNo")
  private String buyerNo;

  /**
   * 销方公司编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 红冲时间
   */
  @TableField("reverseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reverseTime;

  /**
   * 红字信息表编号
   */
  @TableField("redLetterNumber")
  private String redLetterNumber;

  /**
   * PDF文件地址
   */
  @TableField("pdfUrl")
  private String pdfUrl;

  /**
   * 购方地址
   */
  @TableField("buyerAddress")
  private String buyerAddress;

  /**
   * 购方电话
   */
  @TableField("buyerTel")
  private String buyerTel;

  /**
   * 购方地址电话
   */
  @TableField("buyerAddressTel")
  private String buyerAddressTel;

  /**
   * 购方银行名称
   */
  @TableField("buyerBankName")
  private String buyerBankName;

  /**
   * 购方银行账号
   */
  @TableField("buyerBankAccount")
  private String buyerBankAccount;

  /**
   * 购方银行名称账号
   */
  @TableField("buyerBankInfo")
  private String buyerBankInfo;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方地址电话
   */
  @TableField("sellerAddressTel")
  private String sellerAddressTel;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 销方银行名称账号
   */
  @TableField("sellerBankInfo")
  private String sellerBankInfo;

  /**
   * 发票备注
   */
  private String remark;

  /**
   * 原发票号码
   */
  @TableField("originalInvoiceNo")
  private String originalInvoiceNo;

  /**
   * 原发票代码
   */
  @TableField("originalInvoiceCode")
  private String originalInvoiceCode;

  /**
   * 发票类型
   */
  @TableField("invoiceKind")
  private String invoiceKind;

  /**
   * 发票状态
   */
  private String status;

  /**
   * 红冲状态
   */
  @TableField("reverseStatus")
  private String reverseStatus;

  /**
   * 红蓝票标记
   */
  @TableField("invoiceColor")
  private String invoiceColor;

  /**
   * 预览地址
   */
  @TableField("viewUrl")
  private String viewUrl;

  /**
   * 全电 XML 地址
   */
  @TableField("xmlUrl")
  private String xmlUrl;

  /**
   * OFD文件地址
   */
  @TableField("ofdUrl")
  private String ofdUrl;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 账户类型
   */
  @TableField("accountType")
  private String accountType;

  /**
   * 国税发票来源
   */
  @TableField("taxInvoiceSource")
  private String taxInvoiceSource;

  /**
   * 业务单号
   */
  @TableField("bizOrderNo")
  private String bizOrderNo;

  /**
   * 二维密文
   */
  @TableField("cipherTextQRCode")
  private String cipherTextQRCode;

  /**
   * 发票样式
   */
  @TableField("invoiceStyleType")
  private String invoiceStyleType;

  /**
   * 是否有销货清单
   */
  @TableField("saleListFileFlag")
  private Boolean saleListFileFlag;

  /**
   * 发票特殊类型标识
   */
  @TableField("specialType")
  private String specialType;

  /**
   * 销方租户代码
   */
  @TableField("sellerTenantCode")
  private String sellerTenantCode;

  /**
   * 购方租户代码
   */
  @TableField("buyerTenantCode")
  private String buyerTenantCode;

  /**
   * 发票来源
   */
  @TableField("dataSource")
  private String dataSource;

  /**
   * 发票来源
   */
  @TableField("invoiceSource")
  private String invoiceSource;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 红冲原因
   */
  @TableField("customRedFlushReason")
  private String customRedFlushReason;

  /**
   * 作废原因
   */
  @TableField("customAbandonReason")
  private String customAbandonReason;

  /**
   * 特殊发票标志
   */
  @TableField("specialInvoiceFlag")
  private String specialInvoiceFlag;

  /**
   * 特殊附加信息
   */
  @TableField("specialAdditions")
  private String specialAdditions;

  /**
   * 系统来源
   */
  private String source;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("originalInvoiceType", originalInvoiceType);
      map.put("originalDateIssued", originalDateIssued);
      map.put("electronicSignature", electronicSignature);
      map.put("channel", channel);
      map.put("printContentFlag", printContentFlag);
      map.put("reverser", reverser);
      map.put("printStatus", printStatus);
      map.put("cancellationTime", BocpGenUtils.toTimestamp(cancellationTime));
      map.put("cancellationUser", cancellationUser);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("dateIssued", dateIssued);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("buyerName", buyerName);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("machineCode", machineCode);
      map.put("checkCode", checkCode);
      map.put("cipherText", cipherText);
      map.put("payee", payee);
      map.put("reviewer", reviewer);
      map.put("issuer", issuer);
      map.put("buyerNo", buyerNo);
      map.put("sellerNo", sellerNo);
      map.put("reverseTime", BocpGenUtils.toTimestamp(reverseTime));
      map.put("redLetterNumber", redLetterNumber);
      map.put("pdfUrl", pdfUrl);
      map.put("buyerAddress", buyerAddress);
      map.put("buyerTel", buyerTel);
      map.put("buyerAddressTel", buyerAddressTel);
      map.put("buyerBankName", buyerBankName);
      map.put("buyerBankAccount", buyerBankAccount);
      map.put("buyerBankInfo", buyerBankInfo);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddressTel", sellerAddressTel);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("sellerBankInfo", sellerBankInfo);
      map.put("remark", remark);
      map.put("originalInvoiceNo", originalInvoiceNo);
      map.put("originalInvoiceCode", originalInvoiceCode);
      map.put("invoiceKind", invoiceKind);
      map.put("status", status);
      map.put("reverseStatus", reverseStatus);
      map.put("invoiceColor", invoiceColor);
      map.put("viewUrl", viewUrl);
      map.put("xmlUrl", xmlUrl);
      map.put("ofdUrl", ofdUrl);
      map.put("taxRate", taxRate);
      map.put("accountType", accountType);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("bizOrderNo", bizOrderNo);
      map.put("cipherTextQRCode", cipherTextQRCode);
      map.put("invoiceStyleType", invoiceStyleType);
      map.put("saleListFileFlag", saleListFileFlag);
      map.put("specialType", specialType);
      map.put("sellerTenantCode", sellerTenantCode);
      map.put("buyerTenantCode", buyerTenantCode);
      map.put("dataSource", dataSource);
      map.put("invoiceSource", invoiceSource);
      map.put("invoiceType", invoiceType);
      map.put("customRedFlushReason", customRedFlushReason);
      map.put("customAbandonReason", customAbandonReason);
      map.put("specialInvoiceFlag", specialInvoiceFlag);
      map.put("specialAdditions", specialAdditions);
      map.put("source", source);

      return map;
  }

  public static FilterSalesInvoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FilterSalesInvoice entity = new FilterSalesInvoice();
    if(map.containsKey("originalInvoiceType")) {
      Object obj = map.get("originalInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalDateIssued")) {
      Object obj = map.get("originalDateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElectronicSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrintContentFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverser")) {
      Object obj = map.get("reverser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReverser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printStatus")) {
      Object obj = map.get("printStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrintStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancellationTime")) {
      Object obj = map.get("cancellationTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCancellationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCancellationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCancellationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCancellationTime(null);
      }
    }
    if(map.containsKey("cancellationUser")) {
      Object obj = map.get("cancellationUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCancellationUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateIssued")) {
      Object obj = map.get("dateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReviewer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuer")) {
      Object obj = map.get("issuer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerNo")) {
      Object obj = map.get("buyerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseTime")) {
      Object obj = map.get("reverseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReverseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReverseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReverseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReverseTime(null);
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddressTel")) {
      Object obj = map.get("buyerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankInfo")) {
      Object obj = map.get("buyerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddressTel")) {
      Object obj = map.get("sellerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseStatus")) {
      Object obj = map.get("reverseStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReverseStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewUrl")) {
      Object obj = map.get("viewUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setViewUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextQRCode")) {
      Object obj = map.get("cipherTextQRCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherTextQRCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStyleType")) {
      Object obj = map.get("invoiceStyleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStyleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setSaleListFileFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleListFileFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("specialType")) {
      Object obj = map.get("specialType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTenantCode")) {
      Object obj = map.get("buyerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSource")) {
      Object obj = map.get("invoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customRedFlushReason")) {
      Object obj = map.get("customRedFlushReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomRedFlushReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customAbandonReason")) {
      Object obj = map.get("customAbandonReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomAbandonReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialAdditions")) {
      Object obj = map.get("specialAdditions");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialAdditions((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("originalInvoiceType")) {
      Object obj = map.get("originalInvoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalDateIssued")) {
      Object obj = map.get("originalDateIssued");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalDateIssued((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElectronicSignature((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrintContentFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reverser")) {
      Object obj = map.get("reverser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReverser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("printStatus")) {
      Object obj = map.get("printStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrintStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cancellationTime")) {
      Object obj = map.get("cancellationTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCancellationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCancellationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCancellationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCancellationTime(null);
      }
    }
    if(map.containsKey("cancellationUser")) {
      Object obj = map.get("cancellationUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCancellationUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dateIssued")) {
      Object obj = map.get("dateIssued");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDateIssued((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMachineCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCipherText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReviewer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issuer")) {
      Object obj = map.get("issuer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerNo")) {
      Object obj = map.get("buyerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reverseTime")) {
      Object obj = map.get("reverseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReverseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReverseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReverseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReverseTime(null);
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedLetterNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPdfUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerAddressTel")) {
      Object obj = map.get("buyerAddressTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerAddressTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerBankInfo")) {
      Object obj = map.get("buyerBankInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddressTel")) {
      Object obj = map.get("sellerAddressTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddressTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceKind((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reverseStatus")) {
      Object obj = map.get("reverseStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReverseStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("viewUrl")) {
      Object obj = map.get("viewUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setViewUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXmlUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOfdUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cipherTextQRCode")) {
      Object obj = map.get("cipherTextQRCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCipherTextQRCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceStyleType")) {
      Object obj = map.get("invoiceStyleType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStyleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setSaleListFileFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSaleListFileFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("specialType")) {
      Object obj = map.get("specialType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerTenantCode")) {
      Object obj = map.get("buyerTenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceSource")) {
      Object obj = map.get("invoiceSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customRedFlushReason")) {
      Object obj = map.get("customRedFlushReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomRedFlushReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customAbandonReason")) {
      Object obj = map.get("customAbandonReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomAbandonReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialAdditions")) {
      Object obj = map.get("specialAdditions");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialAdditions((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSource((String)obj);
        }
      } else {
      }
    }
  }
}
