package com.xforceplus.jcliutao.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcliutao.entity.CompanyObj;
import com.xforceplus.jcliutao.service.ICompanyObjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-15
 */
@RestController
public class CompanyObjController {

  @Autowired
  private ICompanyObjService companyObjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param companyObj ${table.comment}
   * @return
   */
  @GetMapping("/companyobjs" )
  public XfR getCompanyObjs(XfPage page, CompanyObj companyObj) {
    return XfR.ok(companyObjServiceImpl.page(page, Wrappers.query(companyObj)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/companyobjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(companyObjServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param companyObj ${table.comment}
   * @return XfR
   */
  @PostMapping("/companyobjs")
  public XfR save(@RequestBody CompanyObj companyObj) {
     return XfR.ok(companyObjServiceImpl.save(companyObj));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param companyObj ${table.comment}
   * @return XfR
   */
  @PutMapping("/companyobjs/{id}")
  public XfR putUpdate(@RequestBody CompanyObj companyObj,@PathVariable Long id) {
      companyObj.setId(id);
      return XfR.ok(companyObjServiceImpl.updateById(companyObj));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param companyObj ${table.comment}
   * @return XfR
   */
  @PatchMapping("/companyobjs/{id}")
  public XfR patchUpdate(@RequestBody CompanyObj companyObj,@PathVariable Long id) {
      CompanyObj upcompanyObj = companyObjServiceImpl.getById(id);
      if(upcompanyObj != null){
        upcompanyObj = ObjectCopyUtils.copyProperties(companyObj,upcompanyObj,true);
      }
      return XfR.ok(companyObjServiceImpl.updateById(upcompanyObj));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/companyobjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(companyObjServiceImpl.removeById(id));
  }

  @PostMapping("/companyobjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "company_obj");
     params.put("request", condition);

     return XfR.ok(companyObjServiceImpl.querys(params));
  }

}
