package com.xforceplus.jcliutao.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcliutao.entity.LoadPDFSelect;
import com.xforceplus.jcliutao.service.ILoadPDFSelectService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-15
 */
@RestController
public class LoadPDFSelectController {

  @Autowired
  private ILoadPDFSelectService loadPDFSelectServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param loadPDFSelect ${table.comment}
   * @return
   */
  @GetMapping("/loadpdfselects" )
  public XfR getLoadPDFSelects(XfPage page, LoadPDFSelect loadPDFSelect) {
    return XfR.ok(loadPDFSelectServiceImpl.page(page, Wrappers.query(loadPDFSelect)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/loadpdfselects/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(loadPDFSelectServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param loadPDFSelect ${table.comment}
   * @return XfR
   */
  @PostMapping("/loadpdfselects")
  public XfR save(@RequestBody LoadPDFSelect loadPDFSelect) {
     return XfR.ok(loadPDFSelectServiceImpl.save(loadPDFSelect));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param loadPDFSelect ${table.comment}
   * @return XfR
   */
  @PutMapping("/loadpdfselects/{id}")
  public XfR putUpdate(@RequestBody LoadPDFSelect loadPDFSelect,@PathVariable Long id) {
      loadPDFSelect.setId(id);
      return XfR.ok(loadPDFSelectServiceImpl.updateById(loadPDFSelect));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param loadPDFSelect ${table.comment}
   * @return XfR
   */
  @PatchMapping("/loadpdfselects/{id}")
  public XfR patchUpdate(@RequestBody LoadPDFSelect loadPDFSelect,@PathVariable Long id) {
      LoadPDFSelect uploadPDFSelect = loadPDFSelectServiceImpl.getById(id);
      if(uploadPDFSelect != null){
        uploadPDFSelect = ObjectCopyUtils.copyProperties(loadPDFSelect,uploadPDFSelect,true);
      }
      return XfR.ok(loadPDFSelectServiceImpl.updateById(uploadPDFSelect));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/loadpdfselects/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(loadPDFSelectServiceImpl.removeById(id));
  }

  @PostMapping("/loadpdfselects/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "load_p_d_f_select");
     params.put("request", condition);

     return XfR.ok(loadPDFSelectServiceImpl.querys(params));
  }

}
