package com.xforceplus.jcliutao.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcliutao.entity.Lttest;
import com.xforceplus.jcliutao.service.ILttestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-15
 */
@RestController
public class LttestController {

  @Autowired
  private ILttestService lttestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lttest ${table.comment}
   * @return
   */
  @GetMapping("/lttests" )
  public XfR getLttests(XfPage page, Lttest lttest) {
    return XfR.ok(lttestServiceImpl.page(page, Wrappers.query(lttest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/lttests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lttestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param lttest ${table.comment}
   * @return XfR
   */
  @PostMapping("/lttests")
  public XfR save(@RequestBody Lttest lttest) {
     return XfR.ok(lttestServiceImpl.save(lttest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param lttest ${table.comment}
   * @return XfR
   */
  @PutMapping("/lttests/{id}")
  public XfR putUpdate(@RequestBody Lttest lttest,@PathVariable Long id) {
      lttest.setId(id);
      return XfR.ok(lttestServiceImpl.updateById(lttest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param lttest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/lttests/{id}")
  public XfR patchUpdate(@RequestBody Lttest lttest,@PathVariable Long id) {
      Lttest uplttest = lttestServiceImpl.getById(id);
      if(uplttest != null){
        uplttest = ObjectCopyUtils.copyProperties(lttest,uplttest,true);
      }
      return XfR.ok(lttestServiceImpl.updateById(uplttest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lttests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lttestServiceImpl.removeById(id));
  }

  @PostMapping("/lttests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lttest");
     params.put("request", condition);

     return XfR.ok(lttestServiceImpl.querys(params));
  }

}
